<?php

class Ultimate_AI_Theme_Setting_Manager
{
	private $theme_settings_key = "ultimate_ai_theme_settings";

	function ultimate_ai_save_theme_settings( $settings ){
		$prev_settings = get_option( $this->theme_settings_key, [] );

		foreach( $settings as $key => $value ) {
			$prev_settings[ $key ] = $value;
		}
		update_option( $this->theme_settings_key, $prev_settings );

		return $prev_settings;
	}

	function ultimate_ai_get_theme_settings($keys=[]){
		$prev_settings = get_option( $this->theme_settings_key, [] );
		$result = [];
		foreach( $keys as $key ) {
			$result[$key] = $prev_settings[$key] ?? [];
		}
		return $result;
	}

}
